<?php
require_once 'header.php';
?>

<div class="container ctwhite">

	<h1><?=translate('payment_rates')?></h1>
	
	<div class="alert alert-warning">
	<?=translate('payrates_subparagraph')?> 
	</div>
	

	<table class="table table-bordered table-hover">
		<thead>
			<th><?=translate('country')?></th>
			<th><?=translate('country_code')?></th>
			<th><?=translate('price_per_k')?></th>
		</thead>
		<tbody>
			<?php
			$pricing = $db->get_results("SELECT pricing.pID, pricing.country, pricing.price_k, countries.country as cname  
			                           FROM pricing, countries WHERE pricing.country = countries.ccode ORDER BY price_k DESC");
			foreach($pricing as $p) {
				$pub_price = number_format(($p->price_k*USER_PERCENT_PER_K)/100, 2);
				print '<tr>';
				print '<td>'.$p->cname.'</td>';
				print '<td>'.$p->country.'</td>';
				print '<td>$'.$pub_price.'</td>';
				print '</tr>';
			}						
			?>
		</tbody>
	</table>

</div>

<?php
require_once 'footer.php';
?>